<?php

namespace App\Services\ElectronicBilling\Builders;

use App\Services\ElectronicBilling\Builders\AbstractXmlBuilder;

class FacturaElectronicaBuilder extends AbstractXmlBuilder
{
    protected function getRootNodeName(): string
    {
        return 'FacturaElectronica';
    }

    protected function getNamespaceUrl(): string
    {
        return 'https://cdn.comprobanteselectronicos.go.cr/xml-schemas/v4.4/facturaElectronica';
    }

    protected function getSchemaUrl(): string
    {
        return 'https://cdn.comprobanteselectronicos.go.cr/xml-schemas/v4.4/facturaElectronica.xsd';
    }

    protected function getBuildSteps(): array { 
        return [ 
            'buildHeader', 
            'buildIssuer', 
            'buildReceiver', 
            'buildConditionOfSale', 
            'buildDetail', 
            'buildSummary', 
        ]; 
    }
}