<?php

namespace App\Factories;

use App\Services\ElectronicBilling\Builders\AbstractXmlBuilder;
use App\Services\ElectronicBilling\Builders\FacturaElectronicaBuilder;
use App\Services\ElectronicBilling\Builders\NotaCreditoBuilder;
use App\Services\ElectronicBilling\Builders\NotaDebitoBuilder;
use App\Services\ElectronicBilling\Builders\TiqueteElectronicoBuilder;

class ElectronicDocumentFactory
{
    public const DOC_FE = '01';
    public const DOC_TE = '04';
    public const DOC_NC = '03';
    public const DOC_ND = '02';

    public static function create(string $type): AbstractXmlBuilder
    {
        return match ($type) 
        {
            self::DOC_FE => new FacturaElectronicaBuilder(),
            self::DOC_TE => new TiqueteElectronicoBuilder(),
            self::DOC_NC => new NotaCreditoBuilder(),
            self::DOC_ND => new NotaDebitoBuilder(),
            // ...
            default => throw new \InvalidArgumentException("Tipo de documento no encontrado: $type"),
        };
    }
}
