<?php

namespace App\Http\Requests\Documents;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\DB;

class EliminarSucursal extends FormRequest
{
    public function authorize(): bool
    {
        $cliente = $this->attributes->get('cliente');
        $sucursalId = $this->route('sucursalId');

        return DB::table('sucursales')
            ->where('id', $sucursalId)
            ->where('cliente_id', $cliente->id)
            ->exists();
    }

    public function rules()
    {
        return [];
    }
}