<?php

namespace App\Http\Requests\Documents;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class AddCredentials extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            "cert_file"         => 'required|file|extensions:p12,pfx',
            "cert_pin"          => 'required|string',
            "mh_username"       => 'required|string',
            "mh_password"       => 'required|string',
            "mh_environment"    => 'required|in:sandbox,production',
        ];
    }
}