<?php

namespace App\Http\Controllers\Api\Hacienda;

use Illuminate\Http\JsonResponse;

use Symfony\Component\HttpFoundation\Response;

use App\Http\Controllers\ApiController;
use App\HttpClients\DTOs\Hacienda\DocStatusResponse;
use App\Jobs\ProcessWebhookHaciendaJob;

class WebhookHaciendaController extends ApiController
{
    public function __construct() {}

    public function __invoke(DocStatusResponse $request): JsonResponse
    {
        dispatch(
            new ProcessWebhookHaciendaJob($request->key, $request)
        );

        return response()->json(['message' => 'Webhook accepted.'], Response::HTTP_ACCEPTED);
    }
}