<?php

namespace App\Http\Attributes;

use Attribute;
use Illuminate\Container\Container;
use Illuminate\Contracts\Container\ContextualAttribute;


#[Attribute(Attribute::TARGET_PARAMETER)]
class CurrentClient implements ContextualAttribute
{
    public static function resolve(self $attribute, Container $container)
    {
        $cliente = $container->make('request')->attributes->get('cliente', []);

        return [$cliente] ? $cliente : [];
    }
}