<?php

namespace App\Enums;

enum TipoDocumento: string
{
    case FE   = '01'; // Factura electrónica
    case ND   = '02'; // Nota débito
    case NC   = '03'; // Nota crédito
    case TE   = '04'; // Tiquete electrónico
    case CCE  = '05'; // Confirmación aceptación
    case CPCE = '06'; // Confirmación aceptación parcial
    case RCE  = '07'; // Confirmación rechazo
    case FEC  = '08'; // Factura electrónica de compra
    case FEE  = '09'; // Factura electrónica de exportación

    public function label(): string
    {
        return match ($this) {
            self::FE   => 'Factura electrónica',
            self::ND   => 'Nota débito',
            self::NC   => 'Nota crédito',
            self::TE   => 'Tiquete electrónico',
            self::CCE  => 'Confirmación aceptación',
            self::CPCE => 'Confirmación aceptación parcial',
            self::RCE  => 'Confirmación rechazo',
            self::FEC  => 'Factura electrónica de compra',
            self::FEE  => 'Factura electrónica de exportación',
        };
    }

    public function consecutivoCol(): string
    {
        return match ($this) {
            self::FE => 'consec_fe',
            self::TE => 'consec_te',
            self::NC => 'consec_nc',
            self::ND => 'consec_db'
        };
    }
}
