<?php

namespace App\Services;

use Illuminate\Support\Facades\DB;

use App\HttpClients\Factories\TipoCambioClientFactory;

use DateTimeImmutable;
use DateTimeZone;

class TipoCambioService 
{
    public function obtenerCambioActual(array $providers)
    {
        $date = new DateTimeImmutable('today', new DateTimeZone('America/Costa_Rica'));
        
        $cached = DB::table('tipo_cambio')
            ->where('fecha', $date->format('Y-m-d'))
            ->first();
        
        if ($cached) { 
            return $this->formatResponse(
                $cached->fecha, 
                (float) $cached->venta, 
                (float) $cached->compra
            ); 
        }
        
        foreach ($providers as $provider) 
        {
            $client = TipoCambioClientFactory::make($provider);
            $dto = $client->getActual();

            DB::table('tipo_cambio')->updateOrInsert([
                'fecha' => $dto->fecha->format('Y-m-d')
            ], [
                'venta' => $dto->venta, 
                'compra' => $dto->compra
            ]);

            return $this->formatResponse(
                $dto->fecha->format('Y-m-d'),
                $dto->venta,
                $dto->compra
            );
        }

        throw new \RuntimeException('No tipo de cambio disponible');
    }

    private function formatResponse(string $fecha, float $venta, float $compra): array { 
        return [
            'moneda' => 'USD', 
            'fecha' => $fecha, 
            'venta' => round($venta, 2), 
            'compra' => round($compra, 2), 
        ]; 
    }
}