<?php

namespace App\Http\Requests\Documents;

use App\Enums\TipoIdentificacion;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class AddCliente extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            "nombre"                    => 'required|string|min:10|max:100',
            "tipo_identificacion"       => Rule::enum(TipoIdentificacion::class),
            "numero_identificacion"     => 'required|string',
            "pin"                       => 'required|string|min:6|max:6',
        ];
    }
}