<?php

namespace App\Data;

use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class CreateDocRequest extends Data
{
    public function __construct(
        public ?string $clave,
        public ?string $numero_consecutivo,
        public ?string $fecha_emision,
        
        public string $condicion_venta,
        public string $medio_pago,
        public array $lineas,
        public ?array $resumen = null
    ) {}

    public function finalize(string $clave, string $consecutivo, string $fecha): self
    {
        return new self(
            clave: $clave,
            numero_consecutivo: $consecutivo,
            fecha_emision: $fecha,
            condicion_venta: $this->condicion_venta,
            medio_pago: $this->medio_pago,
            lineas: $this->lineas,
            resumen: $this->resumen
        );
    }
}
