<?php
declare(strict_types=1);

namespace App\Core;

class Autoloader
{
    public static function register(): void
    {
        spl_autoload_register(function (string $class): void {
            if (strpos($class, 'App\\') !== 0) {
                return;
            }

            $relative = substr($class, 4); // quitar "App\"
            $relativePath = str_replace('\\', DIRECTORY_SEPARATOR, $relative) . '.php';

            $file = __DIR__ . '/../' . $relativePath;

            if (is_file($file)) {
                require $file;
            }
        });
    }
}
