<?php
declare(strict_types=1);

namespace App\Database;

use App\Core\Config;
use PDO;
use PDOException;
use RuntimeException;

class Connection
{
    private static ?PDO $pdo = null;

    public static function getPdo(): PDO
    {
        if (self::$pdo instanceof PDO) {
            return self::$pdo;
        }

        $db = Config::get('db');

        if (!is_array($db)) {
            throw new RuntimeException('Config de BD no encontrada');
        }

        $host    = $db['host']     ?? 'localhost';
        $port    = (int)($db['port'] ?? 3306);
        $dbname  = $db['dbname']   ?? '';
        $user    = $db['user']     ?? '';
        $pass    = $db['password'] ?? '';
        $charset = $db['charset']  ?? 'utf8mb4';

        $dsn = "mysql:host={$host};port={$port};dbname={$dbname};charset={$charset}";

        try {
            $pdo = new PDO($dsn, $user, $pass, [
                PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES   => false,
            ]);
        } catch (PDOException $e) {
            throw new RuntimeException('Error al conectar a la base de datos: ' . $e->getMessage());
        }

        self::$pdo = $pdo;
        return $pdo;
    }
}
