<?php
declare(strict_types=1);

namespace App\Core;

use Throwable;

class Logger
{
    public static function error(Throwable $e): void
    {
        $date = date('Y-m-d');
        $time = date('Y-m-d H:i:s');

        $logDir = BASE_PATH . '/storage/logs';
        if (!is_dir($logDir)) {
            @mkdir($logDir, 0775, true);
        }

        $file = $logDir . "/app-{$date}.log";

        $message = sprintf(
            "[%s] %s in %s:%d\nStack trace:\n%s\n\n",
            $time,
            $e->getMessage(),
            $e->getFile(),
            $e->getLine(),
            $e->getTraceAsString()
        );

        @file_put_contents($file, $message, FILE_APPEND);
    }
}
