<?php
declare(strict_types=1);

namespace App\Security;

use App\Http\Request;
use App\Http\HttpException;
use App\Database\Connection;
use PDO;

class ApiAuth
{
    /**
     * Valida la API key contra la tabla clientes_api y
     * agrega la info del cliente al Request.
     *
     * @throws HttpException
     */
    public static function requireValidKey(Request $request): void
    {
        $key = $request->header('X-API-KEY');

        if (!$key) {
            throw new HttpException('Falta API key', 401);
        }

        $pdo = Connection::getPdo();

        $sql = "
            SELECT id, ambiente, activo
            FROM clientes_api
            WHERE api_key = :api_key
            LIMIT 1
        ";

        $stmt = $pdo->prepare($sql);
        $stmt->execute([':api_key' => $key]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$row) {
            throw new HttpException('API key inválida', 401);
        }

        if ((int)$row['activo'] !== 1) {
            throw new HttpException('Cliente inactivo', 403);
        }

        $clientId  = (int)$row['id'];
        $ambiente  = (string)$row['ambiente']; // 'pruebas' o 'produccion'

        // Guardar info del cliente en el Request
        $request->setClientInfo($clientId, $ambiente);
    }
}
