<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Http\Request;
use App\Http\Response;
use App\Http\HttpException;
use App\Security\ApiAuth;
use App\Services\ExoneracionService;

class ExoneracionController
{
    /**
     * GET /api/v1/exoneraciones/consultar?autorizacion=AL-00052264-21[&refresh=1]
     */
    public function consultar(Request $request): void
    {
        ApiAuth::requireValidKey($request);

        $autorizacion = isset($_GET['autorizacion']) ? (string)$_GET['autorizacion'] : '';
        $autorizacion = trim($autorizacion);

        if ($autorizacion === '') {
            throw new HttpException('Debe enviar el parámetro autorizacion', 422);
        }

        $forceRefresh = isset($_GET['refresh']) && $_GET['refresh'] === '1';

        $resultado = ExoneracionService::consultarPorAutorizacion($autorizacion, $forceRefresh);

        if ($resultado === null) {
            throw new HttpException('Exoneración no encontrada o no disponible', 404);
        }

        Response::json([
            'ok'                     => true,
            'autorizacion'           => $resultado['autorizacion'],
            'numero_documento'       => $resultado['numero_documento'],
            'tipo_documento'         => $resultado['tipo_documento'],
            'nombre_institucion'     => $resultado['nombre_institucion'],
            'porcentaje_exoneracion' => $resultado['porcentaje_exoneracion'],
            'fecha_inicio'           => $resultado['fecha_inicio'],
            'fecha_fin'              => $resultado['fecha_fin'],
            'estado'                 => $resultado['estado'],
            'condicion'              => $resultado['condicion'],
            'cabys_autorizados'      => $resultado['cabys_autorizados'],
            'warning'                => $resultado['warning'] ?? null,
        ]);
    }
}
