<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Http\Request;
use App\Http\Response;
use App\Http\HttpException;
use App\Security\ApiAuth;
use App\Services\ContribuyenteService;

class ContribuyenteController
{
    /**
     * GET index.php?r=api/v1/contribuyentes/consultar&identificacion=XXXXXXXXX[&refresh=1]
     *
     * Parámetros:
     *  - identificacion: cédula física/jurídica/DIMEX/NITE (9–12 dígitos).
     *  - refresh (opcional): si es "1", fuerza consulta a Hacienda ignorando caché.
     */
    public function consultar(Request $request): void
    {
        ApiAuth::requireValidKey($request);

        $identificacion = isset($_GET['identificacion']) ? (string)$_GET['identificacion'] : '';
        $identificacion = trim($identificacion);

        if ($identificacion === '') {
            throw new HttpException('Debe enviar el parámetro identificacion', 422);
        }

        $forceRefresh = isset($_GET['refresh']) && $_GET['refresh'] === '1';

        $resultado = ContribuyenteService::consultar($identificacion, $forceRefresh);

        if ($resultado === null) {
            throw new HttpException('Contribuyente no encontrado o no disponible en este momento', 404);
        }

        Response::json([
            'ok'           => true,
            'identificacion' => $resultado['identificacion'],
            'nombre'       => $resultado['nombre'],
            'tipo'         => $resultado['tipo_identificacion'],
            'situacion'    => $resultado['situacion'],
            'regimen'      => $resultado['regimen'],
            'es_extranjero'=> $resultado['es_extranjero'],
            'actividades'  => $resultado['actividades'],
            // Si el Service agregó algún warning (ej: 429), lo exponemos
            'warning'      => $resultado['warning'] ?? null,
        ]);
    }
}
